/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/


#ifndef B_NTPCI_H_INCLUDED
#define B_NTPCI_H_INCLUDED

#define FALSE 0
#define TRUE 1

#include <asm/types.h>
#include <linux/pci.h>

//#include <xpci.h>       // PCI status/connect          (%VOBDIR%\capi)
#include <xtimeout.h>   // SCR; timeouts added 26.11.97

#define DEV_VERSION "0.0.1 (C), Sep 19, 2001"

#define BESTPCI_MAJOR 123

#define NTIO_TYPE_PCI (u32)41000

// Driver Name
#define BEST_PCI_DRIVER "BestNTPci_C"

#define INVALID_HPSLOTID        0xFFFFFFFF
#define INVALID_BASE_IOADDR     0xFFFFFFFF
#define INVALID_DATA            0xFFFFFFFF
#define	DEVICE_HAS_NO_OWNER		0xFFFFFFFF
#define	DEVICE_OWNER_UNKNOWN    0xFFFFFFFE

// These are "our" vendor codes
enum {
  HP_VENDOR_ID	    =  0x103c,	/* "old" HP vendor ID */
  AGILENT_VENDOR_ID =  0x15bc	/* Agilent vendor ID */
};

enum {
  /* "old" PCI cards: */
  HP_DEVICE_2925      = 0x2925,
  HP_DEVICE_2926      = 0x2926,
  HP_DEVICE_2927      = 0x2927,
  HP_DEVICE_2928      = 0x2928,
  HP_DEVICE_2940      = 0x2940,

  /* for PCI-X cards: new Device IDs */
  AGILENT_DEVICE_2922 =  0x2922, /* E2922A */
  AGILENT_DEVICE_2929 =  0x2929, /* E2929A */
  AGILENT_DEVICE_2923 =  0x2923, /* E2923A */
  AGILENT_DEVICE_2930 =  0x2930, /* E2930A */

  /* PCI Express Gen2 cards */
  AGILENT_DEVICE_2960 =  0x2960  /* E2960A and E2960B */
  /* PCI Express Gen3 cards */
  AGILENT_DEVICE_4305 =  0x4305  /* U4305A */
};

// Special (to HP/Agilent) structure used at the application level (C-API)
typedef union {
        struct {
            __u8   functionnumber:3;
            __u8   devicenumber:5;
            __u8   busnumber:8;
            __u16  reserved:16;
        } bits;
        __u32   as_ulong;
} hp_slot_id;

// defines for direct I/O
#define IO_ACCESS_ENABLED   0x0001

// For DecoderStatus
#define     DECODER_DISABLED    0x00000000
#define     DECODER_ENABLED     0x00000001
#define     DECODER_LOADED      0x00000002
#define     DECODER_READY       0x00000003  // enabled and loaded

// driver local data structure specific to each device object
// 12/5/97; additional fields for multiple devices.
typedef struct {
  __u8             enumdevice;				// 0 based index of this device (safety)
  __u32            devicetype;				// Our private Device Type
  __u8             regwidth;				  // register width, 1, 2 or 4
  hp_slot_id     slot_id;				  // our "special" format

  // for direct I/O read/write
  __u32            decoderstatus;          // Bits: DECODER_ENABLED, DECODER_LOADED
  __u8             f_using_direct_io;         // Are we using direct I/O?

  // Base address decoded (index 2 = MINI decoder)
  // These registers are copies of PCI_COMMON_CONFIG members
  void           *baseaddress;      // .u.type0.BaseAddresses[PCI_TYPE0_ADDRESSES]
  __u32            baselen;

  // N.B. This is definitely overkill but all of the uses for these devices
  //		are not yet defined so I built for any eventuality.
  __u8             f_device_open;			// device has been opened by a user-process
  __u8             f_is_hp_best_device;  // device is actually a HP Best card.
  __u8             f_is_2925;          // device is a 2925
  __u8             f_is_2926;          // device is a 2926

  __u16            device_id;
  __u16            vendor_id;
  __u16            sub_vendor_id;
  __u16            sub_device_id;
  __u16            class;

  BESTTIMEOUTS    commtimeouts;     /* SCR; 26.11.97 */
} bestpci_device_info;

typedef struct {
  unsigned char *version;
  int dev_count;
} bestpci_general_info;


#ifdef __KERNEL__
/********************* function prototypes ***********************************/

static int bestpci_open(struct inode *inode, struct file *file);
static int bestpci_close(struct inode *inode, struct file *file);
static int bestpci_write(struct file *file, const char *buf, size_t count, loff_t *ppos);
static int bestpci_read(struct file *file, char *buf, size_t count, loff_t *ppos);
static int bestpci_ioctl(struct inode *inode, struct file *file, unsigned int cmd, unsigned long arg);

static int bestpci_probe(struct pci_dev *dev, const struct pci_device_id *id);
static void bestpci_remove(struct pci_dev *dev);
void bestpci_disconnect(struct pci_dev *dev);
u32 bestpci_direct_reg_read(struct pci_dev *dev,bx_accessporttype *pPortData);
void bestpci_direct_reg_write(struct pci_dev *dev,bx_accessportdatatype *pPortData);
void bestpci_write_config_dw(struct pci_dev *dev,bx_configdrivertype *data);
u32 bestpci_read_config_dw(struct pci_dev *dev,u32 data);

#endif // __KERNEL__

#endif  // #ifndef B_NTPCI_H_INCLUDED

